if exist('REVS','var') && (REVS.verbose > 0)  disp(['Loading ' mfilename]); end

transmission_type           = enum_transmission_type.DCT;
transmission_thermal_type   = enum_transmission_thermal_type.constant_temperature;

transmission                = class_REVS_DCT_transmission;
transmission.matrix_vintage = enum_matrix_vintage.present;
transmission.name           = mfilename; 

transmission.control = class_REVS_DCT_control;
transmission.control.disengage_speed_radps      = 93.095875511966; 
transmission.control.disengage_max_gear         = Inf; 
transmission.control.engage_pedal_norm          = 0.020000000; 
transmission.control.engage_speed_radps         = [     78.539816,	   104.71976,	 ]; 
transmission.control.engage_modulation_max_gear = 1.0000000; 
transmission.control.engage_min_norm            = 0.010000000; 
transmission.control.engage_Ki                  = 0.010000000; 
transmission.control.engage_Kp                  = 0.004000000;

transmission.thermal.temperature_degC           = 40.000000;

transmission.dual_clutch                        = class_REVS_dual_clutch;
transmission.dual_clutch.input_inertia_kgm2     = 0.020000000; 
transmission.dual_clutch.output1_inertia_kgm2   = 0.010000000; 
transmission.dual_clutch.output2_inertia_kgm2   = 0.010000000; 
transmission.dual_clutch.engage_duration_secs   = 0.1500000; 
transmission.dual_clutch.torque_capacity_Nm     = 392.40000;

transmission.dual_clutch.input_torque_loss_Nm.axis_1.breakpoints    = [     20.000000,	   30.000000,	   40.000000,	   80.000000,	 ]; 
transmission.dual_clutch.input_torque_loss_Nm.axis_1.signal         = 'trans_temp_degC'; 
transmission.dual_clutch.input_torque_loss_Nm.axis_2.breakpoints    = [    0.00000000,	   1.0000000,	   2.0000000,	   3.0000000,	   4.0000000,	   5.0000000,	   6.0000000,	   7.0000000,	   8.0000000,	 ]; 
transmission.dual_clutch.input_torque_loss_Nm.axis_2.signal         = 'gear_num'; 
transmission.dual_clutch.input_torque_loss_Nm.axis_3.breakpoints    = [    0.00000000,	   250.00000,	 ]; 
transmission.dual_clutch.input_torque_loss_Nm.axis_3.signal         = 'trans_trq_in_Nm'; 
transmission.dual_clutch.input_torque_loss_Nm.axis_4.breakpoints    = [     83.775804,	   418.87902,	 ]; 
transmission.dual_clutch.input_torque_loss_Nm.axis_4.signal         = 'trans_spd_in_radps'; 
transmission.dual_clutch.input_torque_loss_Nm.table(:,:,1,1) = [
  0.80000000,   0.80000000,   0.90000000,    1.2000000,    1.5000000,    1.9000000,    2.3000000,    2.9000000,    2.9000000, ;
  0.70000000,   0.70000000,   0.90000000,    1.1000000,    1.4000000,    1.8000000,    2.2000000,    2.7000000,    2.7000000, ;
  0.70000000,   0.70000000,   0.80000000,    1.0000000,    1.3000000,    1.7000000,    2.1000000,    2.5000000,    2.5000000, ;
  0.40000000,   0.40000000,   0.50000000,   0.70000000,   0.90000000,    1.2000000,    1.5000000,    1.9000000,    1.9000000, ]; 
transmission.dual_clutch.input_torque_loss_Nm.table(:,:,2,1) = [
  0.80000000,    7.8000000,    6.2000000,    5.0000000,    5.3000000,    5.3000000,    5.6000000,    5.9000000,    5.9000000, ;
  0.70000000,    7.7000000,    6.2000000,    5.0000000,    5.2000000,    5.1000000,    5.5000000,    5.8000000,    5.8000000, ;
  0.70000000,    7.7000000,    6.1000000,    4.9000000,    5.2000000,    5.0000000,    5.4000000,    5.6000000,    5.6000000, ;
  0.40000000,    7.5000000,    5.9000000,    4.6000000,    4.8000000,    4.6000000,    4.9000000,    5.0000000,    5.0000000, ]; 
transmission.dual_clutch.input_torque_loss_Nm.table(:,:,1,2) = [
   2.1000000,    2.1000000,    2.2000000,    2.4000000,    2.9000000,    3.5000000,    4.4000000,    5.6000000,    5.6000000, ;
   1.9000000,    1.9000000,    2.0000000,    2.3000000,    2.7000000,    3.3000000,    4.1000000,    5.2000000,    5.2000000, ;
   1.8000000,    1.8000000,    1.9000000,    2.1000000,    2.5000000,    3.1000000,    3.9000000,    4.8000000,    4.8000000, ;
   1.2000000,    1.2000000,    1.3000000,    1.5000000,    1.8000000,    2.3000000,    2.9000000,    3.7000000,    3.7000000, ]; 
transmission.dual_clutch.input_torque_loss_Nm.table(:,:,2,2) = [
   2.1000000,    7.4000000,    6.2000000,    5.5000000,    5.9000000,    6.1000000,    7.0000000,    7.8000000,    7.8000000, ;
   1.9000000,    7.3000000,    6.0000000,    5.3000000,    5.7000000,    6.0000000,    6.7000000,    7.5000000,    7.5000000, ;
   1.8000000,    7.1000000,    5.9000000,    5.2000000,    5.5000000,    5.8000000,    6.4000000,    7.2000000,    7.2000000, ;
   1.2000000,    6.6000000,    5.3000000,    4.6000000,    4.9000000,    5.0000000,    5.5000000,    6.0000000,    6.0000000, ]; 

transmission.gear.common_input_inertia_kgm2     = 0.02500000; 
transmission.gear.common_output_inertia_kgm2    = 0.02500000; 
transmission.gear.number                        = [    0.00000000,	   1.0000000,	   2.0000000,	   3.0000000,	   4.0000000,	   5.0000000,	   6.0000000,	   7.0000000,	   8.0000000,	 ]; 
transmission.gear.ratio                         = [    0.00000000,	   4.7000000,	   3.1300000,	   2.1000000,	   1.6700000,	   1.2900000,	   1.0000000,	  0.84000000,	  0.67000000,	 ];
% gear losses are represented in input torque loss, for this data set
transmission.gear.efficiency_norm               = [     1.0000000,	   1.0000000,	   1.0000000,	   1.0000000,	   1.0000000,	   1.0000000,	   1.0000000,	   1.0000000,	   1.0000000,	 ]; 
transmission.gear.inertia_kgm2                  = [    0.00000000,	  0.00000000,	  0.00000000,	  0.00000000,	  0.00000000,	  0.00000000,	  0.00000000,	  0.00000000,	  0.00000000,	 ]; 
transmission.gear.shift_duration_secs           = 0.15000000; 

transmission.gear1                                          = class_REVS_gearbox;
transmission.gear1.type                                     = enum_transmission_type.DCT;
transmission.gear1.number                                   = [    0.00000000,	   1.0000000,	   3.0000000,	   5.0000000,	   7.0000000,	 ]; 
transmission.gear1.ratio                                    = [    0.00000000,	   4.7000000,	   2.1000000,	   1.2900000,	  0.84000000,	 ]; 
transmission.gear1.inertia_kgm2                             = [    0.00000000,	  0.00000000,	  0.00000000,	  0.00000000,	  0.00000000,	 ]; 
transmission.gear1.efficiency_norm.axis_1.breakpoints       = [    0.00000000,	   1.0000000,	   3.0000000,	   5.0000000,	   7.0000000,	 ]; 
transmission.gear1.efficiency_norm.axis_1.signal            = 'core.gearbox1.gb_cmd_gear'; 
transmission.gear1.efficiency_norm.table                    = [     1.0000000,	   1.0000000,	   1.0000000,	   1.0000000,	   1.0000000,	 ]; 
transmission.gear1.common_input_inertia_kgm2                = 0.0125; 
transmission.gear1.common_output_inertia_kgm2               = 0.0125; 
transmission.gear1.input_torque_loss_Nm.axis_1.breakpoints  = [    0.00000000,	   1000000.0,	 ]; 
transmission.gear1.input_torque_loss_Nm.axis_1.signal       = 'core.gearbox1.gb_spd_in_radps'; 
transmission.gear1.input_torque_loss_Nm.table               = [    0.00000000,	  0.00000000,	 ]; 
transmission.gear1.output_torque_loss_Nm.axis_1.breakpoints = [    0.00000000,	   1000000.0,	 ]; 
transmission.gear1.output_torque_loss_Nm.axis_1.signal      = 'core.gearbox1.gb_spd_out_radps'; 
transmission.gear1.output_torque_loss_Nm.table              = [    0.00000000,	  0.00000000,	 ]; 
transmission.gear1.shift_duration_secs                      = 0.15000000; 

transmission.gear2                                          = class_REVS_gearbox;
transmission.gear2.type                                     = enum_transmission_type.DCT;
transmission.gear2.number                                   = [    0.00000000,	   2.0000000,	   4.0000000,	   6.0000000,	   8.0000000,	 ]; 
transmission.gear2.ratio                                    = [    0.00000000,	   3.1300000,	   1.6700000,	   1.0000000,	  0.67000000,	 ]; 
transmission.gear2.inertia_kgm2                             = [    0.00000000,	  0.00000000,	  0.00000000,	  0.00000000,	  0.00000000,	 ]; 
transmission.gear2.efficiency_norm.axis_1.breakpoints       = [    0.00000000,	   2.0000000,	   4.0000000,	   6.0000000,	   8.0000000,	 ]; 
transmission.gear2.efficiency_norm.axis_1.signal            = 'core.gearbox2.gb_cmd_gear'; 
transmission.gear2.efficiency_norm.table                    = [     1.0000000,	   1.0000000,	   1.0000000,	   1.0000000,	   1.0000000,	 ]; 
transmission.gear2.common_input_inertia_kgm2                = 0.0125; 
transmission.gear2.common_output_inertia_kgm2               = 0.0125; 
transmission.gear2.input_torque_loss_Nm.axis_1.breakpoints  = [    0.00000000,	   1000000.0,	 ]; 
transmission.gear2.input_torque_loss_Nm.axis_1.signal       = 'core.gearbox2.gb_spd_in_radps'; 
transmission.gear2.input_torque_loss_Nm.table               = [    0.00000000,	  0.00000000,	 ]; 
transmission.gear2.output_torque_loss_Nm.axis_1.breakpoints = [    0.00000000,	   1000000.0,	 ]; 
transmission.gear2.output_torque_loss_Nm.axis_1.signal      = 'core.gearbox2.gb_spd_out_radps'; 
transmission.gear2.output_torque_loss_Nm.table              = [    0.00000000,	  0.00000000,	 ]; 
transmission.gear2.shift_duration_secs                      = 0.15000000; 

transmission_gear_select                                    = enum_transmission_gear_select.ALPHAshift;
transmission.gear_strategy                                  = class_REVS_ALPHAshift;
transmission.gear_strategy.launch_gear_num                  = 1.0000000; 
transmission.gear_strategy.restrict_skip_shifts             = 0.00000000; 
transmission.gear_strategy.restrict_shift_parity            = 1.0000000; 
transmission.gear_strategy.min_speed_radps                  = [    0.00000000,	   95.000000,	   98.042857,	   101.08571,	   104.12857,	   107.17143,	   110.21429,	   113.25714,	   116.30000,	 ]; 
transmission.gear_strategy.min_speed_shift_increment        = [     1.0000000,	   1.0000000,	   1.0000000,	   1.0000000,	   1.0000000,	   1.0000000,	   1.0000000,	   1.0000000,	   1.0000000,	 ]; 
transmission.gear_strategy.max_speed_radps                  = [     621.93216,	   621.93216,	   621.93216,	   621.93216,	   621.93216,	   621.93216,	   621.93216,	   621.93216,	   621.93216,	 ]; 
transmission.gear_strategy.max_speed_shift_increment        = [     1.0000000,	   1.0000000,	   1.0000000,	   1.0000000,	   1.0000000,	   1.0000000,	   1.0000000,	   1.0000000,	   1.0000000,	 ]; 
transmission.gear_strategy.downshift_delay_secs             = [    0.10000000,	  0.10000000,	  0.10000000,	  0.10000000,	  0.10000000,	  0.10000000,	  0.10000000,	  0.10000000,	  0.10000000,	 ]; 
transmission.gear_strategy.downshift_commit_secs            = [    0.80000000,	  0.80000000,	  0.80000000,	  0.80000000,	  0.80000000,	  0.80000000,	  0.80000000,	  0.80000000,	  0.80000000,	 ]; 
transmission.gear_strategy.downshift_max_speed_radps        = [     497.54573,	   497.54573,	   497.54573,	   497.54573,	   497.54573,	   497.54573,	   497.54573,	   497.54573,	   497.54573,	 ]; 
transmission.gear_strategy.disable_cost_saving_downshifts   = 1; 
transmission.gear_strategy.upshift_min_speed_radps          = [     106.20000,	   106.20000,	   108.04286,	   111.08571,	   114.12857,	   117.17143,	   120.21429,	   123.25714,	   126.30000,	 ]; 
transmission.gear_strategy.upshift_delay_secs               = [    0.10000000,	  0.10000000,	  0.10000000,	  0.10000000,	  0.10000000,	  0.10000000,	  0.10000000,	  0.10000000,	  0.10000000,	 ]; 
transmission.gear_strategy.upshift_commit_secs              = [    0.80000000,	  0.80000000,	  0.80000000,	  0.80000000,	  0.80000000,	  0.80000000,	  0.80000000,	  0.80000000,	  0.80000000,	 ]; 
transmission.gear_strategy.upshift_min_torque_reserve_ratio = [     1.0000000,	   1.0000000,	   1.0800000,	   1.0800000,	   1.0800000,	   1.0800000,	   1.0800000,	   1.0800000,	   1.0800000,	 ]; 
transmission.gear_strategy.kickdown_trigger_ratio           = [     1.5000000,	   1.5000000,	   1.5000000,	   1.5000000,	   1.5000000,	   1.4250000,	   1.3500000,	   1.3500000,	   1.3500000,	 ]; 
transmission.gear_strategy.kickdown_delay_secs              = [   0.100000000,	 0.100000000,	 0.100000000,	 0.100000000,	 0.100000000,	 0.100000000,	 0.100000000,	 0.100000000,	 0.100000000,	 ]; 
transmission.gear_strategy.kickdown_shift_increment         = [     1.0000000,	;    1.0000000,	;    1.0000000,	;    1.0000000,	;    1.0000000,	;    1.0000000,	;    1.0000000,	;    1.0000000,	;    1.0000000,	 ]; 
transmission.gear_strategy.kickdown_min_gear                = 1.0000000; 
transmission.gear_strategy.kickdown_max_increment           = 1.0000000; 
transmission.gear_strategy.use_engine_speed_mask            = [    0.00000000,	  0.00000000,	  0.00000000,	  0.00000000,	  0.00000000,	  0.00000000,	  0.00000000,	  0.00000000,	  0.00000000,	 ]; 
transmission.gear_strategy.max_input_torque_curve_Nm        = [    0.00000000,	   218.07800,	   219.37500,	   219.37500,	   219.37500,	   219.37500,	   219.37500,	   219.37500,	   168.41900,	  0.00000000,	 ]; 
transmission.gear_strategy.max_input_torque_speeds_radps    = [    0.00000000,	   143.37100,	   172.45400,	   223.67400,	   409.60900,	   430.24700,	   469.98900,	   471.32700,	   678.36700,	   690.00000,	 ]; 
transmission.gear_strategy.required_cost_benefit_ratio      = [     1.0000000,	   1.0100000,	   1.0100000,	   1.0100000,	   1.0100000,	   1.0100000,	   1.0100000,	   1.0100000,	   1.0100000,	 ]; 
transmission.gear_strategy.cost_map_speed_radps             = [    0.00000000,	   20.944000,	   41.887900,	   62.831900,	   83.775800,	   104.72000,	   125.66400,	   146.60800,	   167.55200,	   188.49600,	   209.44000,	   230.38300,	   251.32700,	   272.27100,	   293.21500,	   314.15900,	   335.10300,	   356.04700,	   376.99100,	   397.93500,	   418.87900,	   439.82300,	   460.76700,	   481.71100,	   502.65500,	   523.59900,	   544.54300,	   565.48700,	   586.43100,	   607.37500,	   628.31900,	   649.26200,	   670.20600,	   691.15000,	 ]; 
transmission.gear_strategy.cost_map_torque_Nm               = [    -56.250000,	  -45.000000,	  -33.750000,	  -22.500000,	  -11.250000,	  0.00000000,	   11.250000,	   22.500000,	   33.750000,	   45.000000,	   56.250000,	   67.500000,	   78.750000,	   90.000000,	   101.25000,	   112.50000,	   123.75000,	   135.00000,	   146.25000,	   157.50000,	   168.75000,	   180.00000,	   191.25000,	   202.50000,	   213.75000,	   225.00000,	   236.25000,	   247.50000,	   258.75000,	   270.00000,	 ]; 
transmission.gear_strategy.cost_map = [
  0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000, ;
  0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000, ;
  0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000, ;
  0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000, ;
  0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000,   0.00000000, ;
  0.00000000,   0.16104817,   0.46898494,   0.76859890,    1.0574561,    1.3475374,    1.6593767,    1.9967780,    2.3107488,    2.6135750,    3.0093242,    3.4453294,    3.8791382,    4.2801594,    4.6914980,    5.2201338,    5.9163628,    6.6138826,    7.1367442,    7.5506078,    7.9426470,    8.5823630,    9.6708258,    10.877926,    12.172581,    13.574562,    15.047092,    16.449725,    17.599412,    18.499236,    19.116844,    19.689421,    20.530764,    21.599188, ;
 0.058781138,   0.15086428,   0.24091458,   0.32968235,   0.42285496,   0.52378667,   0.62948200,   0.73704779,   0.85323635,   0.98729462,    1.1218415,    1.2640468,    1.4033691,    1.5291603,    1.6384463,    1.7913373,    1.9964025,    2.1878267,    2.3255454,    2.4722627,    2.6420466,    2.8557678,    3.1207481,    3.3809100,    3.6353417,    3.9201403,    4.3022208,    4.7266877,    5.1303819,    5.4775962,    5.5665253,    5.5705644,    5.8031818,    6.1707158, ;
  0.10230719,   0.16681001,   0.23006629,   0.29015271,   0.34962985,   0.43548139,   0.52543158,   0.59210058,   0.68372501,   0.77917302,   0.87665019,   0.99531373,    1.1024127,    1.2071111,    1.3067161,    1.4174143,    1.5593002,    1.7045104,    1.8148617,    1.9300134,    2.0545276,    2.1930835,    2.3554231,    2.5289298,    2.6405103,    2.7725192,    3.0344193,    3.3611772,    3.6709227,    3.9181197,    3.9920177,    4.0309093,    4.1888407,    4.4153375, ;
  0.14039884,   0.18562448,   0.23501166,   0.29274780,   0.35618402,   0.41164561,   0.49003715,   0.54477376,   0.62493418,   0.71946709,   0.81743289,   0.91739906,    1.0149843,    1.1104364,    1.2109129,    1.3181654,    1.4389016,    1.5662247,    1.6769573,    1.7783271,    1.8823509,    1.9930075,    2.1287318,    2.2736740,    2.3710239,    2.4705624,    2.6540038,    2.8794707,    3.0958808,    3.2809542,    3.3795676,    3.4592005,    3.6139470,    3.8023352, ;
  0.18934871,   0.21162965,   0.23880000,   0.27814224,   0.33773394,   0.39199452,   0.46245039,   0.53972648,   0.61838055,   0.70647033,   0.79332791,   0.88498118,   0.97592277,    1.0698308,    1.1687961,    1.2632134,    1.3693504,    1.4770617,    1.5714781,    1.6673069,    1.7643377,    1.8639345,    1.9908264,    2.1243689,    2.2289240,    2.3331359,    2.4861127,    2.6783518,    2.8709612,    3.0295523,    3.1240074,    3.2081232,    3.3705134,    3.5704539, ;
  0.28123525,   0.28317128,   0.29139308,   0.31890399,   0.38502378,   0.46277377,   0.55195485,   0.64192609,   0.73565754,   0.82866134,   0.92068102,    1.0312227,    1.1378187,    1.2389116,    1.3417892,    1.4522140,    1.5726097,    1.6968823,    1.7919332,    1.8903083,    2.0078301,    2.1339281,    2.2713602,    2.3995060,    2.5115338,    2.6513675,    2.8406214,    3.0451739,    3.2367612,    3.4190112,    3.5095871,    3.6132128,    3.8044514,    4.0430246, ;
  0.35851537,   0.35851537,   0.35851537,   0.37655086,   0.45174604,   0.53217436,   0.63136258,   0.73547571,   0.83437585,   0.93703851,    1.0505534,    1.1760491,    1.2964669,    1.4114721,    1.5283235,    1.6450177,    1.7726588,    1.8991263,    2.0198947,    2.1423342,    2.2654109,    2.3898990,    2.5440232,    2.6973479,    2.8430458,    3.0002029,    3.1980124,    3.4174179,    3.6128508,    3.7814751,    3.9098375,    4.0557248,    4.2298597,    4.4349467, ;
  0.39652495,   0.39900457,   0.40842410,   0.44220343,   0.52706332,   0.60291474,   0.70556225,   0.82045973,   0.93884048,    1.0645121,    1.1831804,    1.3174252,    1.4567792,    1.5788248,    1.6989601,    1.8205529,    1.9688619,    2.1152473,    2.2509167,    2.3810660,    2.5197281,    2.6605025,    2.7972662,    2.9424789,    3.1253877,    3.3181242,    3.5045913,    3.7440310,    3.9581848,    4.1325104,    4.2716899,    4.3928931,    4.6033070,    4.8325099, ;
  0.41245508,   0.44237084,   0.47736573,   0.52655459,   0.60320641,   0.69132592,   0.79856193,   0.92258064,    1.0411629,    1.1737320,    1.3056492,    1.4581172,    1.6030118,    1.7513346,    1.8862836,    2.0163925,    2.1389462,    2.2786393,    2.4601119,    2.6197259,    2.7706926,    2.9348755,    3.0908950,    3.2418012,    3.4152618,    3.6386063,    3.8777134,    4.1092840,    4.3528447,    4.5499059,    4.6873475,    4.8329814,    5.0269204,    5.2263832, ;
  0.45350287,   0.51156794,   0.57310541,   0.64232197,   0.71959453,   0.79427420,   0.91949661,    1.0472047,    1.1680250,    1.3103761,    1.4599557,    1.6181694,    1.7731184,    1.9361396,    2.0892907,    2.2313551,    2.3844444,    2.5456072,    2.7150782,    2.8995149,    3.0699449,    3.2294067,    3.4102868,    3.6007722,    3.7997792,    4.0023323,    4.2992441,    4.5601592,    4.7643876,    4.9673217,    5.1477716,    5.3047476,    5.5046975,    5.7345220, ;
  0.52395256,   0.59912493,   0.67424863,   0.74848590,   0.82123402,   0.89724595,    1.0328102,    1.1446259,    1.2783702,    1.4426384,    1.6155598,    1.7829379,    1.9570826,    2.1151212,    2.2633515,    2.4305546,    2.6068081,    2.7873260,    2.9842558,    3.1749711,    3.3903061,    3.5976614,    3.7740982,    3.9480615,    4.1631966,    4.3841033,    4.6750427,    4.9871037,    5.2299739,    5.4377736,    5.6306558,    5.8071693,    5.9899498,    6.2042471, ;
  0.62228916,   0.70284535,   0.78317759,   0.86269791,   0.94073905,    1.0194190,    1.1267080,    1.2701587,    1.4600009,    1.6041265,    1.7619230,    1.9690708,    2.1279799,    2.2888040,    2.4813292,    2.6323512,    2.8392849,    3.0530204,    3.2636425,    3.4970155,    3.6869390,    3.9330867,    4.1235916,    4.3149831,    4.5666210,    4.8146250,    5.0999763,    5.4434458,    5.7146909,    5.9628854,    6.1489027,    6.3418979,    6.5364624,    6.7010098, ;
  0.74720840,   0.82369592,   0.90131277,   0.98110876,    1.0616233,    1.1402073,    1.2503582,    1.4147948,    1.5872248,    1.7545034,    1.9506699,    2.1232175,    2.3074589,    2.5279302,    2.6751259,    2.8401265,    3.0885497,    3.3119734,    3.5724784,    3.8190192,    4.0452589,    4.2930550,    4.5013057,    4.7022323,    4.9456974,    5.1940341,    5.4864565,    5.8649398,    6.1722143,    6.4448496,    6.6488353,    6.8309678,    7.0391326,    7.2349453, ;
  0.89831148,   0.96408034,    1.0303743,    1.0993857,    1.1758782,    1.2685075,    1.3941189,    1.5759506,    1.7307141,    1.9406935,    2.1158702,    2.3140188,    2.5449575,    2.6987878,    2.9196890,    3.1153497,    3.3649525,    3.6223274,    3.8962571,    4.1892070,    4.4594355,    4.7058357,    4.8224512,    5.0978816,    5.3285655,    5.5840387,    5.9155892,    6.3226680,    6.6541911,    6.9139757,    7.1520703,    7.3563776,    7.5623250,    7.7897530, ;
   1.0707121,    1.1266915,    1.1820482,    1.2388157,    1.3058766,    1.4002066,    1.5301329,    1.6832218,    1.9088540,    2.1091574,    2.3262384,    2.5499042,    2.7335928,    2.9675044,    3.1554270,    3.3866998,    3.6537474,    3.9150740,    4.2619000,    4.5611037,    4.8478496,    5.0980971,    5.2816086,    5.5207232,    5.7665201,    6.0339264,    6.3686202,    6.8192273,    7.1758872,    7.4428984,    7.6495429,    7.8125718,    8.0472442,    8.2833702, ;
   1.2574897,    1.3075611,    1.3576615,    1.4049669,    1.4411648,    1.4976149,    1.6353522,    1.8382410,    2.0965896,    2.3137104,    2.5463112,    2.7417676,    3.0006074,    3.2026679,    3.4302389,    3.6777450,    3.9510572,    4.2570509,    4.6021669,    4.8853272,    5.2230159,    5.5072363,    5.7576821,    6.0041221,    6.2460816,    6.4994488,    6.8736265,    7.3337907,    7.6552599,    7.9158855,    8.1336683,    8.5565104,    8.8190002,    8.8190002, ;
   1.4542786,    1.4921965,    1.5312846,    1.5711546,    1.6058065,    1.6653472,    1.8002996,    2.0139479,    2.2126959,    2.4771580,    2.6990846,    2.9818928,    3.2024697,    3.4831519,    3.7358950,    3.9873215,    4.2730876,    4.5786702,    4.9593386,    5.3070751,    5.6451294,    5.9686165,    6.1846360,    6.4272281,    6.6981587,    7.0149118,    7.4420001,    7.8409538,    8.1350282,    8.4762873,    8.9568443,    9.1765569,    9.3256885,    9.3256885, ;
   1.6566471,    1.6776137,    1.6991092,    1.7253302,    1.7689181,    1.8526155,    1.9842248,    2.1414550,    2.3967337,    2.6552532,    2.9539540,    3.2198177,    3.4935417,    3.7631625,    4.0543763,    4.3485443,    4.6656700,    4.9976418,    5.3114998,    5.7422877,    6.1054102,    6.4144450,    6.6911941,    6.9654665,    7.2445855,    7.5729975,    7.9705228,    8.3386159,    8.8810358,    9.2173493,    9.4629906,    9.4629906,    9.6163685,    9.8256428, ;
   1.8555567,    1.8670629,    1.8796897,    1.8944726,    1.9101141,    1.9564109,    2.0918016,    2.2941045,    2.6001788,    2.8360614,    3.1396160,    3.4665034,    3.7500502,    4.0544553,    4.3329554,    4.6383815,    4.9977391,    5.3390457,    5.7593455,    6.1634682,    6.5180779,    6.8791039,    7.1844652,    7.4620950,    7.7791892,    8.1606639,    8.5553816,    9.0306046,    9.4825432,    9.7269809,    9.7742841,    9.9256627,    10.164354,    10.365205, ;
   2.0399647,    2.0491691,    2.0577845,    2.0650794,    2.0686646,    2.1065925,    2.2561501,    2.4711959,    2.7565424,    3.0848295,    3.4087977,    3.7268552,    4.0354306,    4.3531752,    4.6773309,    5.0293098,    5.4203241,    5.8098289,    6.1900492,    6.5822340,    6.9617123,    7.3133313,    7.6314988,    7.9818229,    8.3776633,    8.5637066,    8.8076542,    9.4983125,    9.7194899,    9.9770303,    10.230392,    10.469122,    10.681946,    10.875683, ;
   2.1944916,    2.2130211,    2.2276000,    2.2367532,    2.2530681,    2.3155978,    2.4594770,    2.6592531,    2.9262835,    3.2740535,    3.6196316,    3.9797977,    4.3222171,    4.6657082,    5.0267778,    5.4169890,    5.7953475,    6.1694651,    6.5607305,    6.9581762,    7.3394972,    7.7422654,    8.1259031,    8.4875173,    8.7270283,    8.8234869,    9.4014639,    9.8783343,    10.237628,    10.526582,    10.757768,    10.983132,    11.190197,    11.375243, ;
   2.3062700,    2.3483959,    2.3899992,    2.4236782,    2.4236782,    2.4416840,    2.5932594,    2.8375061,    3.1194466,    3.4583163,    3.8458944,    4.2225218,    4.5926626,    4.9588164,    5.3438248,    5.7285881,    6.1162484,    6.5180102,    6.9426942,    7.4046050,    7.8323962,    8.2572569,    8.6351520,    8.9364263,    9.2475471,    9.8202647,    10.187658,    10.428049,    10.697471,    11.053997,    11.280683,    11.488446,    11.678635,    11.862066, ;
   2.3782886,    2.4353363,    2.4898924,    2.5346434,    2.5568279,    2.5996679,    2.7567571,    3.0081821,    3.3488339,    3.7061589,    4.0649269,    4.4695080,    4.8510825,    5.2483387,    5.6875404,    6.1197522,    6.5495434,    6.9892544,    7.4188713,    7.8513145,    8.2676899,    8.6879657,    9.0196897,    9.4531427,    9.9380112,    10.330328,    10.660546,    10.971986,    11.182753,    11.552222,    11.788552,    11.990163,    12.174908,    12.343017, ;
   2.4155823,    2.4814275,    2.5460141,    2.6112010,    2.6880187,    2.8008281,    2.9740961,    3.2161880,    3.5391266,    3.8918853,    4.3084199,    4.7346415,    5.1387732,    5.5562553,    5.9841806,    6.4581382,    6.8993731,    7.3428457,    7.7816286,    8.2475789,    8.7054320,    9.1655598,    9.5864397,    10.008936,    10.415269,    10.815850,    11.161234,    11.476861,    11.679022,    12.041470,    12.295830,    12.496396,    12.674034,    12.821989, ;
   2.4330435,    2.5133531,    2.5985700,    2.6970804,    2.8180849,    2.9683503,    3.1547450,    3.4004598,    3.7280620,    4.1227418,    4.5486477,    4.9971983,    5.4142757,    5.8648559,    6.3568466,    6.8273028,    7.2763541,    7.7441304,    8.2101213,    8.6898272,    9.1640898,    9.6192999,    10.052068,    10.488710,    10.910753,    11.306849,    11.662775,    11.972720,    12.191906,    12.517763,    12.803787,    13.022568,    13.186702,    13.322672, ]; 
